;==========================================================
; ASSETS.ASM
; Configuration and Data for Multidesk
;==========================================================

;----------------------------------------------------------
; 1. HARDWARE & LOGIC
;----------------------------------------------------------
USE_PORT_1      = 1   ; For games that use Port 1, diables Keys
TIMEOUT_FRAMES  = 500 ; # of Frames before automatically starting selection

;----------------------------------------------------------
; 2. VISUAL CONFIGURATION
;----------------------------------------------------------

; Color Palette:
COL_BORDER      = $00
COL_BACKGROUND  = $00

; Menu Item Colors
COL_MENU_UNSEL  = $01
COL_MENU_SEL    = $07

; Static Text Colors
COL_INSTRUCTIONS = $0F      
COL_GAMENAME     = $01    
COL_COMMENT      = $0C

;----------------------------------------------------------
; 3. TEXT DATA
;----------------------------------------------------------

; --- Static Strings ---
; max length is 38 (due to border graphic), will be centered
  
TxtGameName:
    !scr "deliverance: stormlord ii  by hewson", 0
;   !scr "12345678901234567890123456789012345678"
    
TxtComment:
    !scr "oneload64 by statmat - menu by docbobo", 0
;   !scr "crt linker by pugsy -- menu by docbobo", 0

ITEM_COUNT      = 3   ; # of menu items, max 5 (6 when comment line empty)
MAX_ITEM_IDX    = ITEM_COUNT - 1

MenuTextBase:
    !scr "level 1 and 2", 0
    !scr "level 3 and 4", 0
    !scr "level 5 and 6", 0
    !scr "dummy 4", 0
    !scr "dummy 5", 0
;   !scr "dummy 6", 0 ; use only when you leave TxtComment: empty!

MenuBanks:
    !byte 1,12,23,0,0,0
    
TxtInstructions:
    !if USE_PORT_1 = 1 {
    !scr "please use joystick in port 1", 0      
    } else {      
    !scr "use joystick in port 2 or keyboard", 0
    }

;----------------------------------------------------------
; 4. SCREEN ASSETS
;----------------------------------------------------------
ScreenData = map_data
ColorData  = map_colour_data

map_data
!byte $ec,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2
!byte $e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2
!byte $e2,$e2,$e2,$e2,$e2,$e2,$e2,$fb,$61,$20,$20,$20,$fc,$20,$6c,$61
!byte $20,$20,$20,$61,$e1,$20,$20,$7c,$20,$20,$20,$61,$20,$20,$20,$20
!byte $20,$20,$61,$20,$20,$6c,$e2,$e2,$e1,$20,$e1,$20,$20,$20,$20,$e1
!byte $61,$20,$20,$20,$61,$7f,$7e,$61,$61,$20,$61,$61,$e1,$e2,$20,$fb
!byte $20,$ff,$e2,$61,$ff,$e2,$61,$ff,$e2,$7e,$61,$6c,$7e,$e1,$62,$62
!byte $e1,$62,$fe,$20,$20,$20,$20,$e1,$61,$20,$20,$20,$61,$20,$20,$61
!byte $61,$20,$61,$61,$e1,$20,$20,$e1,$20,$61,$20,$61,$61,$e2,$7e,$e2
!byte $e2,$61,$61,$7f,$20,$e1,$20,$e1,$20,$20,$e1,$20,$20,$20,$20,$e1
!byte $61,$20,$20,$20,$7e,$20,$20,$7e,$7c,$e2,$7e,$7c,$20,$e2,$7e,$e2
!byte $7e,$e2,$e2,$7e,$e2,$e2,$7e,$e2,$e2,$20,$7e,$20,$7e,$7c,$e2,$7e
!byte $20,$20,$7c,$20,$20,$20,$20,$e1,$61,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$e1
!byte $61,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$e1,$fc,$62,$62,$62,$62,$62,$62,$62
!byte $62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62
!byte $62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$fe
!byte $61,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$e1,$61,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$e1
!byte $61,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$60,$60,$60,$20
!byte $20,$20,$20,$60,$60,$60,$60,$60,$60,$60,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$e1,$ec,$e2,$e2,$e2,$e2,$e2,$e2,$e2
!byte $e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2
!byte $e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$e2,$fb
!byte $61,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$e1,$61,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$e1
!byte $61,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$e1,$61,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$e1
!byte $61,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$e1,$61,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$e1
!byte $61,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$e1,$61,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$e1
!byte $61,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$e1,$61,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$e1
!byte $61,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$e1,$61,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20
!byte $20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$20,$e1
!byte $fc,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62
!byte $62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62,$62
!byte $62,$62,$62,$62,$62,$62,$62,$fe

map_colour_data
!byte $0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b
!byte $0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b
!byte $0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0e,$0e,$01,$0f,$01,$0f,$0f
!byte $01,$01,$01,$0f,$0f,$01,$01,$0f,$01,$01,$01,$0f,$01,$01,$01,$01
!byte $01,$01,$0f,$01,$01,$07,$07,$07,$07,$01,$07,$0e,$0e,$0e,$0e,$0b
!byte $0b,$0e,$0e,$01,$0c,$0c,$0c,$0c,$0c,$01,$0c,$0c,$0c,$0c,$01,$0c
!byte $01,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0a,$0a,$0a
!byte $0a,$0a,$0a,$0e,$0e,$0e,$0e,$0b,$0b,$0e,$0e,$01,$0f,$01,$01,$0f
!byte $0f,$01,$0f,$0f,$0f,$01,$01,$0f,$01,$0f,$01,$0f,$0f,$0f,$0f,$0f
!byte $0f,$0f,$0f,$0f,$01,$05,$01,$05,$01,$01,$05,$0e,$0e,$0e,$0e,$0b
!byte $0b,$0e,$0e,$01,$0c,$01,$01,$0c,$0c,$0c,$0c,$0c,$01,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$01,$0c,$01,$0c,$0e,$0e,$0e
!byte $01,$01,$0e,$0e,$0e,$0e,$0e,$0b,$0b,$0e,$0e,$0e,$0e,$0e,$0e,$0e
!byte $0e,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0e,$0e,$0e,$0e,$0e,$0c,$0c
!byte $0e,$0e,$0e,$0e,$0e,$0e,$0e,$0e,$0e,$0e,$0e,$0e,$0e,$0e,$0e,$0b
!byte $0b,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b
!byte $0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b
!byte $0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b
!byte $0b,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0b,$0b,$0b,$0c,$0c,$0c,$0c,$0c,$0b
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$01,$0b,$0b,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0b
!byte $0b,$0b,$0c,$0c,$0c,$0c,$0c,$0c,$0b,$0b,$0b,$0b,$01,$01,$01,$0b
!byte $0b,$0b,$0b,$01,$01,$01,$01,$01,$01,$01,$0b,$0b,$0b,$0b,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b
!byte $0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b
!byte $0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b
!byte $0b,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0b,$0b,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0b
!byte $0b,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0b,$0b,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0b
!byte $0b,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0b,$0b,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0b
!byte $0b,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0b,$0b,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0b
!byte $0b,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0b,$0b,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0b
!byte $0b,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0b,$0b,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c
!byte $0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0c,$0b
!byte $0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b
!byte $0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b
!byte $0b,$0b,$0b,$0b,$0b,$0b,$0b,$0b