import os
import sys

def pad_file(filename):
    BLOCK_SIZE = 8192
    
    # Check if file exists
    if not os.path.isfile(filename):
        print(f"Error: The file '{filename}' was not found.")
        return

    # Read the original file
    with open(filename, 'rb') as f:
        data = f.read()
    
    original_len = len(data)
    remainder = original_len % BLOCK_SIZE
    
    # Calculate how many bytes needed to reach the next multiple
    if remainder == 0:
        padding_len = 0
    else:
        padding_len = BLOCK_SIZE - remainder
        
    # Create padding of 0xFF bytes
    padding = b'\xff' * padding_len
    new_data = data + padding
    
    # Calculate the number of 8192 chunks
    # Note: Using integer division //
    num_blocks = len(new_data) // BLOCK_SIZE
    
    # Construct the new filename
    # Example: 'image.png' -> 'image_5.png' (if size is 5 blocks)
    root, ext = os.path.splitext(filename)
    new_filename = f"{root}_{num_blocks}{ext}"
    
    # Write the new file
    with open(new_filename, 'wb') as f:
        f.write(new_data)
        
    print(f"Success!")
    print(f"Original size: {original_len} bytes")
    print(f"Padding added: {padding_len} bytes")
    print(f"Final size:    {len(new_data)} bytes ({num_blocks} blocks)")
    print(f"Saved as:      {new_filename}")

if __name__ == "__main__":
    # You can run this by passing the filename as an argument
    # Example: python script.py mydata.bin
    if len(sys.argv) > 1:
        target_file = sys.argv[1]
        pad_file(target_file)
    else:
        # Or simply input it when running the script
        target_file = input("Enter the file name: ")
        # Remove quotes if user dragged-and-dropped file
        target_file = target_file.strip('"').strip("'") 
        pad_file(target_file)